﻿within AixLib.Media.Refrigerants.UsersGuide;
class References "References"
  extends Modelica.Icons.References;


  annotation (Documentation(info="<html>
<p>
In the following, the literature used for the media library is summarised.
</p>
<h4>References regarding the Helmholtz equation of state:</h4>
<p>
R. Span (2000):
<a href=\"http://dx.doi.org/10.1007/978-3-662-04092-8\">
Multiparameter Equations of State: An Accurate Source of Thermodynamic 
Property Data</a>. <i>Springer, Berlin und Heidelberg</i>
</p>
<p>
Thorade, Matthis; Saadat, Ali (2012):
<a href=\"http://www.ep.liu.se/ecp/076/006/ecp12076006.pdf\">HelmholtzMedia -
A fluid properties library</a>. In: <i>Proceedings of the 9th International
Modelica Conference</i>; September 3-5; 2012; Munich; Germany.
Link&ouml;ping University Electronic Press, S. 63&ndash;70.
</p>
<p>
Thorade, Matthis; Saadat, Ali (2013):
<a href=\"http://gfzpublic.gfz-potsdam.de/pubman/item/escidoc:247373:5/component/escidoc:306833/247373.pdf\">
Partial derivatives of thermodynamic state properties for dynamic
simulation</a>. In:<i> Environmental earth sciences 70 (8)</i>,
S. 3497&ndash;3503.
</p>
<h4>References regarding the hybrid approach:</h4>
<p>
Klasing,Freerk: A New Design for Direct Exchange Geothermal Heat Pumps -
Modeling, Simulation and Exergy Analysis. <i>Master thesis</i>
</p>
<p>
Sangi, Roozbeh; Jahangiri, Pooyan; Klasing, Freerk; Streblow, Rita;
M&uuml;ller, Dirk (2014): <a href=\"http://dx.doi.org/10.3384/ecp14096\">
A Medium Model for the Refrigerant Propane for Fast and Accurate Dynamic
Simulations</a>. In: <i>The 10th International Modelica Conference</i>. Lund,
Sweden, March 10-12, 2014: Link&ouml;ping University Electronic Press
(Link&ouml;ping Electronic Conference Proceedings), S. 1271&ndash;1275
</p>
<h4>References regarding refrigerant R134a:</h4>
<p>
Tillner-Roth, R.; Baehr, H. D. (1994): 
<a href=\"http://dx.doi.org/10.1063/1.555958\">
An International Standard Formulation for the thermodynamic Properties of 
1,1,1,2|Tetrafluoroethane (HFC|134a) for Temperatures from 170 K to 455 K 
and Pressures up to 70 MPa</a>. In: <i>Journal of physical and chemical 
reference data (23)</i>, S. 657–729.
</p>
<p>
Perkins, R. A.; Laesecke, A.; Howley, J.; Ramires, M. L. V.; Gurova, A. N.;
Cusco, L. (2000): 
<a href=\"http://ws680.nist.gov/publication/get_pdf.cfm?pub_id=831676\">
Experimental thermal conductivity values for the IUPAC round-robin sample 
of 1,1,1,2-tetrafluoroethane (R134a)</a>. Gaithersburg, MD:
<i>National Institute of Standards and Technology.</i>
</p>
<p>
Huber, Marcia L.; Laesecke, Arno; Perkins, Richard A. (2003): 
<a href=\"http://dx.doi.org/10.1021/ie0300880\">
Model for the Viscosity and Thermal Conductivity of Refrigerants, Including 
a New Correlation for the Viscosity of R134a </a>. In: <i>Ind. Eng. Chem. 
Res. 42 (13)</i>, S. 3163–3178.
</p>
<p>
Mulero, A.; Cachadiña, I.; Parra, M. I. (2012): 
<a href=\"http://dx.doi.org/10.1063/1.4768782\">
Recommended Correlations for the Surface Tension of Common Fluids</a>. 
In: <i>Journal of physical and chemical reference data 41 (4)</i>, 
S. 43105.
</p>
<h4>References regarding refrigerant R290:</h4>
<p>
Klasing,Freerk: A New Design for Direct Exchange Geothermal Heat Pumps -
Modeling, Simulation and Exergy Analysis. <i>Master thesis</i>
</p>
<p>
Sangi, Roozbeh; Jahangiri, Pooyan; Klasing, Freerk; Streblow, Rita;
M&uuml;ller, Dirk (2014): 
<a href=\"http://dx.doi.org/10.3384/ecp14096\">
A Medium Model for the Refrigerant Propane for Fast and Accurate Dynamic
Simulations</a>. In: <i>The 10th International Modelica Conference</i>. Lund,
Sweden, March 10-12, 2014: Link&ouml;ping University Electronic Press
(Link&ouml;ping Electronic Conference Proceedings), S. 1271&ndash;1275
</p>
<p>
Scalabrin, G.; Marchi, P.; Span, R. (2006): 
<a href=\"http://dx.doi.org/10.1063/1.2213629\">
A Reference Multiparameter Viscosity Equation for Propane with an 
Optimized Functional Form</a>. In: <i>J.Phys. Chem. Ref. Data, 
Vol. 35, No. 3</i>, S. 1415-1442
</p>
<h4>References regarding refrigerant R410a:</h4>
<p>
Nabizadeh, H.; Mayinger, F. (1999): 
<a href=\"http://dx.doi.org/10.1007/978-1-4615-4777-8_1\">
Viscosity of Gaseous R404A, R407C, R410A, and R507</a>. 
In: <i>International Journal of Thermophysics 20 (3)</i>, S.
777–790.
</p>
<p>
Geller, V. Z.; Bivens, D.; Yokozeki, A. (2000): 
<a href=\"http://docs.lib.purdue.edu/iracc/508\">
Viscosity of Mixed Refrigerants, R404A, R407C, R410A, and R507C</a>. 
In: <i>International refrigeration and air conditioning conference</i>. 
USA, S. 399–406.
</p>
<p>
Geller, V. Z.; Nemzer, B. V.; Cheremnykh, U. V. (2001): 
<a href=\"http://dx.doi.org/10.1023/A:1010691504352\">
Thermal Conductivity of the Refrigerant Mixtures R404A, R407C, 
R410A, and R507A</a>. In:<i>International Journal of Thermophysics 
22 (4)</i>, 1035–1043.
</p>
<p>
Fröba, A. P.; Leipertz, A. (2003): 
<a href=\"http://dx.doi.org/10.1023/A:1026152331710\">
Thermophysical Properties of the Refrigerant Mixtures R410A and 
R407C from Dynamic Light Scattering (DLS)</a>. In: <i>International 
Journal ofThermophysics 24 (5)</i>, S. 1185–1206.
</p>
<p>
Lemmon, E. W. (2003): 
<a href=\"http://dx.doi.org/10.1023/A:1025048800563\">
Pseudo-Pure Fluid Equations of State for the Refrigerant Blends R-410A,
 R-404A, R-507A, and R-407C</a>. In: <i>International Journal of
Thermophysics 24 (4)</i>, S. 991–1006.
</p>
</html>",
revisions="<html>
<ul>
  <li>
  October 14, 2017, by Mirko Engelpracht:<br/>
  First implementation
  (see <a href=\"https://github.com/RWTH-EBC/AixLib/issues/408\">issue 408</a>).
  </li>
</ul>
</html>"));
end References;
